/* 
* DDRInit.c
*
*Copyright (C) 2010 Beceem Communications, Inc.
*
*This program is free software: you can redistribute it and/or modify 
*it under the terms of the GNU General Public License version 2 as
*published by the Free Software Foundation. 
*
*This program is distributed in the hope that it will be useful,but 
*WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
*See the GNU General Public License for more details.
*
*You should have received a copy of the GNU General Public License
*along with this program. If not, write to the Free Software Foundation, Inc.,
*51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*/


#include<headers.h>

#ifndef BCM_SHM_INTERFACE


#define DDR_DUMP_INTERNAL_DEVICE_MEMORY 		0xBFC02B00
#define MIPS_CLOCK_REG 							0x0f000820
#define DDR_DUMP_MAGIC_PATTERN					0x1d1e0dd0
#define DDR_DUMP_INTERNAL_DEVICE_MEMORY_350    	0xBFC03000


    //DDR INIT-133Mhz
#define T3_SKIP_CLOCK_PROGRAM_DUMP_133MHZ 12  //index for 0x0F007000
static DDR_SET_NODE asT3_DDRSetting133MHz[]= {//      # DPLL Clock Setting
                                        {0x0F000800,0x00007212},
                                        {0x0f000820,0x07F13FFF},
                                        {0x0f000810,0x00000F95},
                                        {0x0f000860,0x00000000},
                                        {0x0f000880,0x000003DD},
                                        // Changed source for X-bar and MIPS clock to APLL
                                        {0x0f000840,0x0FFF1B00},
                                        {0x0f000870,0x00000002},
                                        {0x0F00a044,0x1fffffff},
                                        {0x0F00a040,0x1f000000},
                                        {0x0F00a084,0x1Cffffff},
                                        {0x0F00a080,0x1C000000},
                                        {0x0F00a04C,0x0000000C},
                                        //Memcontroller Default values
                                        {0x0F007000,0x00010001},
                                        {0x0F007004,0x01010100},
                                        {0x0F007008,0x01000001},
                                        {0x0F00700c,0x00000000},
                                        {0x0F007010,0x01000000},
                                        {0x0F007014,0x01000100},
                                        {0x0F007018,0x01000000},
                                        {0x0F00701c,0x01020001},// POP - 0x00020001 Normal 0x01020001
                                        {0x0F007020,0x04030107}, //Normal - 0x04030107 POP - 0x05030107
                                        {0x0F007024,0x02000007},
                                        {0x0F007028,0x02020202},
                                        {0x0F00702c,0x0206060a},//ROB- 0x0205050a,//0x0206060a
                                        {0x0F007030,0x05000000},
                                        {0x0F007034,0x00000003},
                                        {0x0F007038,0x110a0200},//ROB - 0x110a0200,//0x180a0200,// 0x1f0a0200
                                        {0x0F00703C,0x02101010},//ROB - 0x02101010,//0x02101018},
                                        {0x0F007040,0x45751200},//ROB - 0x45751200,//0x450f1200},
                                        {0x0F007044,0x110a0d00},//ROB - 0x110a0d00//0x111f0d00
                                        {0x0F007048,0x081b0306},
                                        {0x0F00704c,0x00000000},
                                        {0x0F007050,0x0000001c},
                                        {0x0F007054,0x00000000},
                                        {0x0F007058,0x00000000},
                                        {0x0F00705c,0x00000000},
                                        {0x0F007060,0x0010246c},
                                        {0x0F007064,0x00000010},
                                        {0x0F007068,0x00000000},
                                        {0x0F00706c,0x00000001},
                                        {0x0F007070,0x00007000},
                                        {0x0F007074,0x00000000},
                                        {0x0F007078,0x00000000},
                                        {0x0F00707C,0x00000000},
                                        {0x0F007080,0x00000000},
                                        {0x0F007084,0x00000000},
                                        //# Enable BW improvement within memory controller
                                        {0x0F007094,0x00000104},
                                        //# Enable 2 ports within X-bar
                                        {0x0F00A000,0x00000016},
                                        //# Enable start bit within memory controller
                                        {0x0F007018,0x01010000}
                                        };
//80Mhz
#define T3_SKIP_CLOCK_PROGRAM_DUMP_80MHZ 10  //index for 0x0F007000
static DDR_SET_NODE asT3_DDRSetting80MHz[]= {//   # DPLL Clock Setting
                                        {0x0f000810,0x00000F95},
                                        {0x0f000820,0x07f1ffff},
                                        {0x0f000860,0x00000000},
                                        {0x0f000880,0x000003DD},
                                        {0x0F00a044,0x1fffffff},
                                        {0x0F00a040,0x1f000000},
                                        {0x0F00a084,0x1Cffffff},
                                        {0x0F00a080,0x1C000000},
                                        {0x0F00a000,0x00000016},
                                        {0x0F00a04C,0x0000000C},
                                //Memcontroller Default values
                                        {0x0F007000,0x00010001},
                                        {0x0F007004,0x01000000},
                                        {0x0F007008,0x01000001},
                                        {0x0F00700c,0x00000000},
                                        {0x0F007010,0x01000000},
                                        {0x0F007014,0x01000100},
                                        {0x0F007018,0x01000000},
                                        {0x0F00701c,0x01020000},
                                        {0x0F007020,0x04020107},
                                        {0x0F007024,0x00000007},
                                        {0x0F007028,0x02020201},
                                        {0x0F00702c,0x0204040a},
                                        {0x0F007030,0x04000000},
                                        {0x0F007034,0x00000002},
                                        {0x0F007038,0x1F060200},
                                        {0x0F00703C,0x1C22221F},
                                        {0x0F007040,0x8A006600},
                                        {0x0F007044,0x221a0800},
                                        {0x0F007048,0x02690204},
                                        {0x0F00704c,0x00000000},
                                        {0x0F007050,0x0000001c},
                                        {0x0F007054,0x00000000},
                                        {0x0F007058,0x00000000},
                                        {0x0F00705c,0x00000000},
                                        {0x0F007060,0x000A15D6},
                                        {0x0F007064,0x0000000A},
                                        {0x0F007068,0x00000000},
                                        {0x0F00706c,0x00000001},
                                        {0x0F007070,0x00004000},
                                        {0x0F007074,0x00000000},
                                        {0x0F007078,0x00000000},
                                        {0x0F00707C,0x00000000},
                                        {0x0F007080,0x00000000},
                                        {0x0F007084,0x00000000},
                                        {0x0F007094,0x00000104},
                                        //# Enable start bit within memory controller
										{0x0F007018,0x01010000}
                                };
//100Mhz
#define T3_SKIP_CLOCK_PROGRAM_DUMP_100MHZ 13  //index for 0x0F007000
static DDR_SET_NODE asT3_DDRSetting100MHz[]= {//  # DPLL Clock Setting
                                        {0x0F000800,0x00007008},
                                        {0x0f000810,0x00000F95},
                                        {0x0f000820,0x07F13E3F},
                                        {0x0f000860,0x00000000},
                                        {0x0f000880,0x000003DD},
                                // Changed source for X-bar and MIPS clock to APLL
                                //0x0f000840,0x0FFF1800,
                                        {0x0f000840,0x0FFF1B00},
                                        {0x0f000870,0x00000002},
                                        {0x0F00a044,0x1fffffff},
                                        {0x0F00a040,0x1f000000},
                                        {0x0F00a084,0x1Cffffff},
                                        {0x0F00a080,0x1C000000},
                                        {0x0F00a04C,0x0000000C},
                                //# Enable 2 ports within X-bar
                                        {0x0F00A000,0x00000016},
                                //Memcontroller Default values
                                        {0x0F007000,0x00010001},
                                        {0x0F007004,0x01010100},
                                        {0x0F007008,0x01000001},
                                        {0x0F00700c,0x00000000},
                                        {0x0F007010,0x01000000},
                                        {0x0F007014,0x01000100},
                                        {0x0F007018,0x01000000},
                                        {0x0F00701c,0x01020001}, // POP - 0x00020000 Normal 0x01020000
                                        {0x0F007020,0x04020107},//Normal - 0x04030107 POP - 0x05030107
                                        {0x0F007024,0x00000007},
                                        {0x0F007028,0x01020201},
                                        {0x0F00702c,0x0204040A},
                                        {0x0F007030,0x06000000},
                                        {0x0F007034,0x00000004},
                                        {0x0F007038,0x20080200},
                                        {0x0F00703C,0x02030320},
                                        {0x0F007040,0x6E7F1200},
                                        {0x0F007044,0x01190A00},
                                        {0x0F007048,0x06120305},//0x02690204 // 0x06120305
                                        {0x0F00704c,0x00000000},
                                        {0x0F007050,0x0000001C},
                                        {0x0F007054,0x00000000},
                                        {0x0F007058,0x00000000},
                                        {0x0F00705c,0x00000000},
                                        {0x0F007060,0x00082ED6},
                                        {0x0F007064,0x0000000A},
                                        {0x0F007068,0x00000000},
                                        {0x0F00706c,0x00000001},
                                        {0x0F007070,0x00005000},
                                        {0x0F007074,0x00000000},
                                        {0x0F007078,0x00000000},
                                        {0x0F00707C,0x00000000},
                                        {0x0F007080,0x00000000},
                                        {0x0F007084,0x00000000},
                                //# Enable BW improvement within memory controller
                                        {0x0F007094,0x00000104},
                                //# Enable start bit within memory controller
                                        {0x0F007018,0x01010000}
                                };

//Net T3B DDR Settings
//DDR INIT-133Mhz
static DDR_SET_NODE asDPLL_266MHZ[] = {
                                        {0x0F000800,0x00007212},
                                        {0x0f000820,0x07F13FFF},
                                        {0x0f000810,0x00000F95},
                                        {0x0f000860,0x00000000},
                                        {0x0f000880,0x000003DD},
                                        // Changed source for X-bar and MIPS clock to APLL
                                        {0x0f000840,0x0FFF1B00},
                                        {0x0f000870,0x00000002}
									  };
#if 0
static DDR_SET_NODE asDPLL_800MHZ[] = {
										{0x0f000810,0x00000F95},
										{0x0f000810,0x00000F95},	
                                        {0x0f000810,0x00000F95},
                                        {0x0f000820,0x03F1365B},
                                        {0x0f000840,0x0FFF0000},
                                        {0x0f000880,0x000003DD},
                                        {0x0f000860,0x00000000}
									  };
#endif

#define T3B_SKIP_CLOCK_PROGRAM_DUMP_133MHZ 11  //index for 0x0F007000
static DDR_SET_NODE asT3B_DDRSetting133MHz[] = {//      # DPLL Clock Setting
                                        {0x0f000810,0x00000F95},
                                        {0x0f000810,0x00000F95},
                                        {0x0f000810,0x00000F95},
                                        {0x0f000820,0x07F13652},
                                        {0x0f000840,0x0FFF0800},
                                        // Changed source for X-bar and MIPS clock to APLL
                                        {0x0f000880,0x000003DD},
                                        {0x0f000860,0x00000000},
                                        // Changed source for X-bar and MIPS clock to APLL
                                        {0x0F00a044,0x1fffffff},
                                        {0x0F00a040,0x1f000000},
                                        {0x0F00a084,0x1Cffffff},
                                        {0x0F00a080,0x1C000000},
                                        //# Enable 2 ports within X-bar
                                        {0x0F00A000,0x00000016},
                                        //Memcontroller Default values
                                        {0x0F007000,0x00010001},
                                        {0x0F007004,0x01010100},
                                        {0x0F007008,0x01000001},
                                        {0x0F00700c,0x00000000},
                                        {0x0F007010,0x01000000},
                                        {0x0F007014,0x01000100},
                                        {0x0F007018,0x01000000},
                                        {0x0F00701c,0x01020001},// POP - 0x00020001 Normal 0x01020001
                                        {0x0F007020,0x04030107}, //Normal - 0x04030107 POP - 0x05030107
                                        {0x0F007024,0x02000007},
                                        {0x0F007028,0x02020202},
                                        {0x0F00702c,0x0206060a},//ROB- 0x0205050a,//0x0206060a
                                        {0x0F007030,0x05000000},
                                        {0x0F007034,0x00000003},
                                        {0x0F007038,0x130a0200},//ROB - 0x110a0200,//0x180a0200,// 0x1f0a0200
                                        {0x0F00703C,0x02101012},//ROB - 0x02101010,//0x02101018},
                                        {0x0F007040,0x457D1200},//ROB - 0x45751200,//0x450f1200},
                                        {0x0F007044,0x11130d00},//ROB - 0x110a0d00//0x111f0d00
                                        {0x0F007048,0x040D0306},
                                        {0x0F00704c,0x00000000},
                                        {0x0F007050,0x0000001c},
                                        {0x0F007054,0x00000000},
                                        {0x0F007058,0x00000000},
                                        {0x0F00705c,0x00000000},
                                        {0x0F007060,0x0010246c},
                                        {0x0F007064,0x00000012},
                                        {0x0F007068,0x00000000},
                                        {0x0F00706c,0x00000001},
                                        {0x0F007070,0x00007000},
                                        {0x0F007074,0x00000000},
                                        {0x0F007078,0x00000000},
                                        {0x0F00707C,0x00000000},
                                        {0x0F007080,0x00000000},
                                        {0x0F007084,0x00000000},
                                        //# Enable BW improvement within memory controller
                                        {0x0F007094,0x00000104},
                                        //# Enable start bit within memory controller
                                        {0x0F007018,0x01010000},
                                        };

#define T3B_SKIP_CLOCK_PROGRAM_DUMP_80MHZ 9  //index for 0x0F007000
static DDR_SET_NODE asT3B_DDRSetting80MHz[] = {//       # DPLL Clock Setting
										{0x0f000810,0x00000F95},
										{0x0f000820,0x07F13FFF},
										{0x0f000840,0x0FFF1F00},
										{0x0f000880,0x000003DD},
										{0x0f000860,0x00000000},

										{0x0F00a044,0x1fffffff},
										{0x0F00a040,0x1f000000},
										{0x0F00a084,0x1Cffffff},
										{0x0F00a080,0x1C000000},
										{0x0F00a000,0x00000016},
										//Memcontroller Default values
										{0x0F007000,0x00010001},
										{0x0F007004,0x01000000},
										{0x0F007008,0x01000001},
										{0x0F00700c,0x00000000},
										{0x0F007010,0x01000000},
										{0x0F007014,0x01000100},
										{0x0F007018,0x01000000},
										{0x0F00701c,0x01020000},
										{0x0F007020,0x04020107},
										{0x0F007024,0x00000007},
										{0x0F007028,0x02020201},
										{0x0F00702c,0x0204040a},
										{0x0F007030,0x04000000},
										{0x0F007034,0x02000002},
										{0x0F007038,0x1F060202},
										{0x0F00703C,0x1C22221F},
										{0x0F007040,0x8A006600},
										{0x0F007044,0x221a0800},
										{0x0F007048,0x02690204},
										{0x0F00704c,0x00000000},
										{0x0F007050,0x0100001c},
										{0x0F007054,0x00000000},
										{0x0F007058,0x00000000},
										{0x0F00705c,0x00000000},
										{0x0F007060,0x000A15D6},
										{0x0F007064,0x0000000A},
										{0x0F007068,0x00000000},
										{0x0F00706c,0x00000001},
										{0x0F007070,0x00004000},
										{0x0F007074,0x00000000},
										{0x0F007078,0x00000000},
										{0x0F00707C,0x00000000},
										{0x0F007080,0x00000000},
										{0x0F007084,0x00000000},
										{0x0F007094,0x00000104},
										//# Enable start bit within memory controller
										{0x0F007018,0x01010000}
								};

//100Mhz
#define T3B_SKIP_CLOCK_PROGRAM_DUMP_100MHZ 9  //index for 0x0F007000
static DDR_SET_NODE asT3B_DDRSetting100MHz[] = {//      # DPLL Clock Setting
										{0x0f000810,0x00000F95},
										{0x0f000820,0x07F1369B},
										{0x0f000840,0x0FFF0800},
										{0x0f000880,0x000003DD},
										{0x0f000860,0x00000000},
										{0x0F00a044,0x1fffffff},
										{0x0F00a040,0x1f000000},
										{0x0F00a084,0x1Cffffff},
										{0x0F00a080,0x1C000000},
										//# Enable 2 ports within X-bar
										{0x0F00A000,0x00000016},
								//Memcontroller Default values
										{0x0F007000,0x00010001},
										{0x0F007004,0x01010100},
										{0x0F007008,0x01000001},
										{0x0F00700c,0x00000000},
										{0x0F007010,0x01000000},
										{0x0F007014,0x01000100},
										{0x0F007018,0x01000000},
										{0x0F00701c,0x01020000}, // POP - 0x00020000 Normal 0x01020000
										{0x0F007020,0x04020107},//Normal - 0x04030107 POP - 0x05030107
										{0x0F007024,0x00000007},
										{0x0F007028,0x01020201},
										{0x0F00702c,0x0204040A},
										{0x0F007030,0x06000000},
										{0x0F007034,0x02000004},
										{0x0F007038,0x20080200},
										{0x0F00703C,0x02030320},
										{0x0F007040,0x6E7F1200},
										{0x0F007044,0x01190A00},
										{0x0F007048,0x06120305},//0x02690204 // 0x06120305
										{0x0F00704c,0x00000000},
										{0x0F007050,0x0100001C},
										{0x0F007054,0x00000000},
										{0x0F007058,0x00000000},
										{0x0F00705c,0x00000000},
										{0x0F007060,0x00082ED6},
										{0x0F007064,0x0000000A},
										{0x0F007068,0x00000000},
										{0x0F00706c,0x00000001},
										{0x0F007070,0x00005000},
										{0x0F007074,0x00000000},
										{0x0F007078,0x00000000},
										{0x0F00707C,0x00000000},
										{0x0F007080,0x00000000},
										{0x0F007084,0x00000000},
								//# Enable BW improvement within memory controller
										{0x0F007094,0x00000104},
								//# Enable start bit within memory controller
										{0x0F007018,0x01010000}
							};


#define T3LP_SKIP_CLOCK_PROGRAM_DUMP_133MHZ 9  //index for 0x0F007000
static DDR_SET_NODE asT3LP_DDRSetting133MHz[]= {//	# DPLL Clock Setting
								{0x0f000820,0x03F1365B},
								{0x0f000810,0x00002F95},
								{0x0f000880,0x000003DD},
								// Changed source for X-bar and MIPS clock to APLL
								{0x0f000840,0x0FFF0000},
								{0x0f000860,0x00000000},
								{0x0F00a044,0x1fffffff},
								{0x0F00a040,0x1f000000},
								{0x0F00a084,0x1Cffffff},
								{0x0F00a080,0x1C000000},
								{0x0F00A000,0x00000016},
								//Memcontroller Default values
								{0x0F007000,0x00010001},
								{0x0F007004,0x01010100},
								{0x0F007008,0x01000001},
								{0x0F00700c,0x00000000},
								{0x0F007010,0x01000000},
								{0x0F007014,0x01000100},
								{0x0F007018,0x01000000},
								{0x0F00701c,0x01020001},// POP - 0x00020001 Normal 0x01020001
								{0x0F007020,0x04030107}, //Normal - 0x04030107 POP - 0x05030107
								{0x0F007024,0x02000007}, 
								{0x0F007028,0x02020200},
								{0x0F00702c,0x0206060a},//ROB- 0x0205050a,//0x0206060a
								{0x0F007030,0x05000000},
								{0x0F007034,0x00000003},
								{0x0F007038,0x200a0200},//ROB - 0x110a0200,//0x180a0200,// 0x1f0a0200
								{0x0F00703C,0x02101020},//ROB - 0x02101010,//0x02101018,
								{0x0F007040,0x45711200},//ROB - 0x45751200,//0x450f1200,
								{0x0F007044,0x110D0D00},//ROB - 0x110a0d00//0x111f0d00
								{0x0F007048,0x04080306},
								{0x0F00704c,0x00000000},
								{0x0F007050,0x0100001c},
								{0x0F007054,0x00000000},
								{0x0F007058,0x00000000},
								{0x0F00705c,0x00000000},
								{0x0F007060,0x0010245F},
								{0x0F007064,0x00000010},
								{0x0F007068,0x00000000},
								{0x0F00706c,0x00000001},
								{0x0F007070,0x00007000},
								{0x0F007074,0x00000000},
								{0x0F007078,0x00000000},
								{0x0F00707C,0x00000000},
								{0x0F007080,0x00000000},
								{0x0F007084,0x00000000},
								{0x0F007088,0x01000001},
								{0x0F00708c,0x00000101},
								{0x0F007090,0x00000000},
								//# Enable BW improvement within memory controller
								{0x0F007094,0x00040000},
								{0x0F007098,0x00000000},
								{0x0F0070c8,0x00000104},
								//# Enable 2 ports within X-bar
								//# Enable start bit within memory controller
								{0x0F007018,0x01010000}
};

#define T3LP_SKIP_CLOCK_PROGRAM_DUMP_100MHZ 11  //index for 0x0F007000
static DDR_SET_NODE asT3LP_DDRSetting100MHz[]= {//	# DPLL Clock Setting
								{0x0f000810,0x00002F95},
								{0x0f000820,0x03F1369B},
								{0x0f000840,0x0fff0000},
								{0x0f000860,0x00000000},
								{0x0f000880,0x000003DD},
								// Changed source for X-bar and MIPS clock to APLL
								{0x0f000840,0x0FFF0000},
								{0x0F00a044,0x1fffffff},
								{0x0F00a040,0x1f000000},
								{0x0F00a084,0x1Cffffff},
								{0x0F00a080,0x1C000000},
								//Memcontroller Default values
								{0x0F007000,0x00010001},
								{0x0F007004,0x01010100},
								{0x0F007008,0x01000001},
								{0x0F00700c,0x00000000},
								{0x0F007010,0x01000000},
								{0x0F007014,0x01000100},
								{0x0F007018,0x01000000},
								{0x0F00701c,0x01020000},// POP - 0x00020001 Normal 0x01020001
								{0x0F007020,0x04020107}, //Normal - 0x04030107 POP - 0x05030107
								{0x0F007024,0x00000007}, 
								{0x0F007028,0x01020200},
								{0x0F00702c,0x0204040a},//ROB- 0x0205050a,//0x0206060a
								{0x0F007030,0x06000000},
								{0x0F007034,0x00000004},
								{0x0F007038,0x1F080200},//ROB - 0x110a0200,//0x180a0200,// 0x1f0a0200
								{0x0F00703C,0x0203031F},//ROB - 0x02101010,//0x02101018,
								{0x0F007040,0x6e001200},//ROB - 0x45751200,//0x450f1200,
								{0x0F007044,0x011a0a00},//ROB - 0x110a0d00//0x111f0d00
								{0x0F007048,0x03000305},
								{0x0F00704c,0x00000000},
								{0x0F007050,0x0100001c},
								{0x0F007054,0x00000000},
								{0x0F007058,0x00000000},
								{0x0F00705c,0x00000000},
								{0x0F007060,0x00082ED6},
								{0x0F007064,0x0000000A},
								{0x0F007068,0x00000000},
								{0x0F00706c,0x00000001},
								{0x0F007070,0x00005000},
								{0x0F007074,0x00000000},
								{0x0F007078,0x00000000},
								{0x0F00707C,0x00000000},
								{0x0F007080,0x00000000},
								{0x0F007084,0x00000000},
								{0x0F007088,0x01000001},
								{0x0F00708c,0x00000101},
								{0x0F007090,0x00000000},
								{0x0F007094,0x00010000},
								{0x0F007098,0x00000000},
								{0x0F0070C8,0x00000104},
								//# Enable 2 ports within X-bar
								{0x0F00A000,0x00000016},
								//# Enable start bit within memory controller
								{0x0F007018,0x01010000}
};

#define T3LP_SKIP_CLOCK_PROGRAM_DUMP_80MHZ 9  //index for 0x0F007000
static DDR_SET_NODE asT3LP_DDRSetting80MHz[]= {//	# DPLL Clock Setting
								{0x0f000820,0x07F13FFF},
								{0x0f000810,0x00002F95},
								{0x0f000860,0x00000000},
								{0x0f000880,0x000003DD},
								{0x0f000840,0x0FFF1F00},
								{0x0F00a044,0x1fffffff},
								{0x0F00a040,0x1f000000},
								{0x0F00a084,0x1Cffffff},
								{0x0F00a080,0x1C000000},
								{0x0F00A000,0x00000016},
								{0x0f007000,0x00010001},
								{0x0f007004,0x01000000},
								{0x0f007008,0x01000001},
								{0x0f00700c,0x00000000},
								{0x0f007010,0x01000000},
								{0x0f007014,0x01000100},
								{0x0f007018,0x01000000},
								{0x0f00701c,0x01020000},
								{0x0f007020,0x04020107},
								{0x0f007024,0x00000007},
								{0x0f007028,0x02020200},
								{0x0f00702c,0x0204040a},
								{0x0f007030,0x04000000},
								{0x0f007034,0x00000002},
								{0x0f007038,0x1d060200},
								{0x0f00703c,0x1c22221d},
								{0x0f007040,0x8A116600},
								{0x0f007044,0x222d0800},
								{0x0f007048,0x02690204},
								{0x0f00704c,0x00000000},
								{0x0f007050,0x0100001c},
								{0x0f007054,0x00000000},
								{0x0f007058,0x00000000},
								{0x0f00705c,0x00000000},
								{0x0f007060,0x000A15D6},
								{0x0f007064,0x0000000A},
								{0x0f007068,0x00000000},
								{0x0f00706c,0x00000001},
								{0x0f007070,0x00004000},
								{0x0f007074,0x00000000},
								{0x0f007078,0x00000000},
								{0x0f00707c,0x00000000},
								{0x0f007080,0x00000000},
								{0x0f007084,0x00000000},
								{0x0f007088,0x01000001},
								{0x0f00708c,0x00000101},
								{0x0f007090,0x00000000},
								{0x0f007094,0x00010000},
								{0x0f007098,0x00000000},
								{0x0F0070C8,0x00000104},
								{0x0F007018,0x01010000}
};




///T3 LP-B (UMA-B)

#define T3LPB_SKIP_CLOCK_PROGRAM_DUMP_160MHZ 7  //index for 0x0F007000
static DDR_SET_NODE asT3LPB_DDRSetting160MHz[]= {//	# DPLL Clock Setting
									
								{0x0f000820,0x03F137DB},
								{0x0f000810,0x01842795},
								{0x0f000860,0x00000000},
								{0x0f000880,0x000003DD},
								{0x0f000840,0x0FFF0400},
								{0x0F00a044,0x1fffffff},
								{0x0F00a040,0x1f000000},
							//	{0x0f003050,0x00000021},//this is flash/eeprom clock divisor which set the flash clock to 20 MHz
								{0x0F00a084,0x1Cffffff},//Now dump from her in internal memory
								{0x0F00a080,0x1C000000},
								{0x0F00A000,0x00000016},
								{0x0f007000,0x00010001},
								{0x0f007004,0x01000001},
								{0x0f007008,0x01000101},
								{0x0f00700c,0x00000000},
								{0x0f007010,0x01000100},
								{0x0f007014,0x01000100},
								{0x0f007018,0x01000000},
								{0x0f00701c,0x01020000},
								{0x0f007020,0x04030107},
								{0x0f007024,0x02000007},
								{0x0f007028,0x02020200},
								{0x0f00702c,0x0206060a},
								{0x0f007030,0x050d0d00},
								{0x0f007034,0x00000003},
								{0x0f007038,0x170a0200},
								{0x0f00703c,0x02101012},
								{0x0f007040,0x45161200},
								{0x0f007044,0x11250c00},
								{0x0f007048,0x04da0307},
								{0x0f00704c,0x00000000},
								{0x0f007050,0x0000001c},
								{0x0f007054,0x00000000},
								{0x0f007058,0x00000000},
								{0x0f00705c,0x00000000},
								{0x0f007060,0x00142bb6},
								{0x0f007064,0x20430014},
								{0x0f007068,0x00000000},
								{0x0f00706c,0x00000001},
								{0x0f007070,0x00009000},
								{0x0f007074,0x00000000},
								{0x0f007078,0x00000000},
								{0x0f00707c,0x00000000},
								{0x0f007080,0x00000000},
								{0x0f007084,0x00000000},
								{0x0f007088,0x01000001},
								{0x0f00708c,0x00000101},
								{0x0f007090,0x00000000},
								{0x0f007094,0x00040000},
								{0x0f007098,0x00000000},
								{0x0F0070C8,0x00000104},
								{0x0F007018,0x01010000},
								{0x0f003050,0x00000021}
};


#define T3LPB_SKIP_CLOCK_PROGRAM_DUMP_133MHZ 7  //index for 0x0F007000
static DDR_SET_NODE asT3LPB_DDRSetting133MHz[]= {//	# DPLL Clock Setting
								{0x0f000820,0x03F1365B},
								{0x0f000810,0x00002F95},
								{0x0f000880,0x000003DD},
								// Changed source for X-bar and MIPS clock to APLL
								{0x0f000840,0x0FFF0000},
								{0x0f000860,0x00000000},
								{0x0F00a044,0x1fffffff},
								{0x0F00a040,0x1f000000},
								{0x0f003050,0x00000021},//flash/eeprom clock divisor which set the flash clock to 20 MHz
								{0x0F00a084,0x1Cffffff},//dump from here in internal memory
								{0x0F00a080,0x1C000000},
								{0x0F00A000,0x00000016},
								//Memcontroller Default values
								{0x0F007000,0x00010001},
								{0x0F007004,0x01010100},
								{0x0F007008,0x01000001},
								{0x0F00700c,0x00000000},
								{0x0F007010,0x01000000},
								{0x0F007014,0x01000100},
								{0x0F007018,0x01000000},
								{0x0F00701c,0x01020001},// POP - 0x00020001 Normal 0x01020001
								{0x0F007020,0x04030107}, //Normal - 0x04030107 POP - 0x05030107
								{0x0F007024,0x02000007}, 
								{0x0F007028,0x02020200},
								{0x0F00702c,0x0206060a},//ROB- 0x0205050a,//0x0206060a
								{0x0F007030,0x05000000},
								{0x0F007034,0x00000003},
								{0x0F007038,0x190a0200},//ROB - 0x110a0200,//0x180a0200,// 0x1f0a0200
								{0x0F00703C,0x02101017},//ROB - 0x02101010,//0x02101018,
								{0x0F007040,0x45171200},//ROB - 0x45751200,//0x450f1200,
								{0x0F007044,0x11290D00},//ROB - 0x110a0d00//0x111f0d00
								{0x0F007048,0x04080306},
								{0x0F00704c,0x00000000},
								{0x0F007050,0x0100001c},
								{0x0F007054,0x00000000},
								{0x0F007058,0x00000000},
								{0x0F00705c,0x00000000},
								{0x0F007060,0x0010245F},
								{0x0F007064,0x00000010},
								{0x0F007068,0x00000000},
								{0x0F00706c,0x00000001},
								{0x0F007070,0x00007000},
								{0x0F007074,0x00000000},
								{0x0F007078,0x00000000},
								{0x0F00707C,0x00000000},
								{0x0F007080,0x00000000},
								{0x0F007084,0x00000000},
								{0x0F007088,0x01000001},
								{0x0F00708c,0x00000101},
								{0x0F007090,0x00000000},
								//# Enable BW improvement within memory controller
								{0x0F007094,0x00040000},
								{0x0F007098,0x00000000},
								{0x0F0070c8,0x00000104},
								//# Enable 2 ports within X-bar
								//# Enable start bit within memory controller
								{0x0F007018,0x01010000}
};

#define T3LPB_SKIP_CLOCK_PROGRAM_DUMP_100MHZ 8  //index for 0x0F007000
static DDR_SET_NODE asT3LPB_DDRSetting100MHz[]= {//	# DPLL Clock Setting
								{0x0f000810,0x00002F95},
								{0x0f000820,0x03F1369B},
								{0x0f000840,0x0fff0000},
								{0x0f000860,0x00000000},
								{0x0f000880,0x000003DD},
								// Changed source for X-bar and MIPS clock to APLL
								{0x0f000840,0x0FFF0000},
								{0x0F00a044,0x1fffffff},
								{0x0F00a040,0x1f000000},
								{0x0f003050,0x00000021},//flash/eeprom clock divisor which set the flash clock to 20 MHz
								{0x0F00a084,0x1Cffffff}, //dump from here in internal memory
								{0x0F00a080,0x1C000000},
								//Memcontroller Default values
								{0x0F007000,0x00010001},
								{0x0F007004,0x01010100},
								{0x0F007008,0x01000001},
								{0x0F00700c,0x00000000},
								{0x0F007010,0x01000000},
								{0x0F007014,0x01000100},
								{0x0F007018,0x01000000},
								{0x0F00701c,0x01020000},// POP - 0x00020001 Normal 0x01020001
								{0x0F007020,0x04020107}, //Normal - 0x04030107 POP - 0x05030107
								{0x0F007024,0x00000007}, 
								{0x0F007028,0x01020200},
								{0x0F00702c,0x0204040a},//ROB- 0x0205050a,//0x0206060a
								{0x0F007030,0x06000000},
								{0x0F007034,0x00000004},
								{0x0F007038,0x1F080200},//ROB - 0x110a0200,//0x180a0200,// 0x1f0a0200
								{0x0F00703C,0x0203031F},//ROB - 0x02101010,//0x02101018,
								{0x0F007040,0x6e001200},//ROB - 0x45751200,//0x450f1200,
								{0x0F007044,0x011a0a00},//ROB - 0x110a0d00//0x111f0d00
								{0x0F007048,0x03000305},
								{0x0F00704c,0x00000000},
								{0x0F007050,0x0100001c},
								{0x0F007054,0x00000000},
								{0x0F007058,0x00000000},
								{0x0F00705c,0x00000000},
								{0x0F007060,0x00082ED6},
								{0x0F007064,0x0000000A},
								{0x0F007068,0x00000000},
								{0x0F00706c,0x00000001},
								{0x0F007070,0x00005000},
								{0x0F007074,0x00000000},
								{0x0F007078,0x00000000},
								{0x0F00707C,0x00000000},
								{0x0F007080,0x00000000},
								{0x0F007084,0x00000000},
								{0x0F007088,0x01000001},
								{0x0F00708c,0x00000101},
								{0x0F007090,0x00000000},
								{0x0F007094,0x00010000},
								{0x0F007098,0x00000000},
								{0x0F0070C8,0x00000104},
								//# Enable 2 ports within X-bar
								{0x0F00A000,0x00000016},
								//# Enable start bit within memory controller
								{0x0F007018,0x01010000}
};

#define T3LPB_SKIP_CLOCK_PROGRAM_DUMP_80MHZ 7  //index for 0x0F007000
static DDR_SET_NODE asT3LPB_DDRSetting80MHz[]= {//	# DPLL Clock Setting
								{0x0f000820,0x07F13FFF},
								{0x0f000810,0x00002F95},
								{0x0f000860,0x00000000},
								{0x0f000880,0x000003DD},
								{0x0f000840,0x0FFF1F00},
								{0x0F00a044,0x1fffffff},
								{0x0F00a040,0x1f000000},
								{0x0f003050,0x00000021},//flash/eeprom clock divisor which set the flash clock to 20 MHz
								{0x0F00a084,0x1Cffffff},// dump from here in internal memory
								{0x0F00a080,0x1C000000},
								{0x0F00A000,0x00000016},
								{0x0f007000,0x00010001},
								{0x0f007004,0x01000000},
								{0x0f007008,0x01000001},
								{0x0f00700c,0x00000000},
								{0x0f007010,0x01000000},
								{0x0f007014,0x01000100},
								{0x0f007018,0x01000000},
								{0x0f00701c,0x01020000},
								{0x0f007020,0x04020107},
								{0x0f007024,0x00000007},
								{0x0f007028,0x02020200},
								{0x0f00702c,0x0204040a},
								{0x0f007030,0x04000000},
								{0x0f007034,0x00000002},
								{0x0f007038,0x1d060200},
								{0x0f00703c,0x1c22221d},
								{0x0f007040,0x8A116600},
								{0x0f007044,0x222d0800},
								{0x0f007048,0x02690204},
								{0x0f00704c,0x00000000},
								{0x0f007050,0x0100001c},
								{0x0f007054,0x00000000},
								{0x0f007058,0x00000000},
								{0x0f00705c,0x00000000},
								{0x0f007060,0x000A15D6},
								{0x0f007064,0x0000000A},
								{0x0f007068,0x00000000},
								{0x0f00706c,0x00000001},
								{0x0f007070,0x00004000},
								{0x0f007074,0x00000000},
								{0x0f007078,0x00000000},
								{0x0f00707c,0x00000000},
								{0x0f007080,0x00000000},
								{0x0f007084,0x00000000},
								{0x0f007088,0x01000001},
								{0x0f00708c,0x00000101},
								{0x0f007090,0x00000000},
								{0x0f007094,0x00010000},
								{0x0f007098,0x00000000},
								{0x0F0070C8,0x00000104},
								{0x0F007018,0x01010000}
};

static DDR_SET_NODE asBCS350_DDR2_APLL200_DDR_200MHz[]= {	
	{0x0F000860, 0x00000000},
	{0x0F000830, 0x01088888},
	{0x0F000810, 0x0003E400},
	{0x0F000820, 0x0C233330},
	{0x0F000880, 0x0000000F},
	{0x0F008000, 0x00000020},
	{0x0F008008, 0x1E401010},
	{0x0F00800C, 0x00008018},
	{0x0F008010, 0x0000B000},
	{0x0F008014, 0x0000B000},
	{0x0F008018, 0x0000B000},
	{0x0F00801C, 0x0000B000},
	{0x0F008020, 0x0000A0F0},
	{0x0F008024, 0x00006070},
	{0x0F00802C, 0x00000700},
	{0x0F008030, 0x00001700},
	{0x0F008034, 0x00000700},
	{0x0F008038, 0x00000B00},
	{0x0F00803C, 0x00000B00},
	{0x0F00804C, 0x00000B01},
	{0x0F008050, 0x00001700},
	{0x0F008054, 0x00001B00},
	{0x0F008058, 0x00000A00},
	{0x0F00805C, 0x00001700},
	{0x0F008060, 0x00000A03},
	{0x0F008064, 0x00000A03},
	{0x0F008068, 0x00001700},
	{0x0F00806C, 0x00001200},
	{0x0F008070, 0x00001200},
	{0x0F00A044, 0x1FFFFFFF},
	{0x0F00A040, 0x10000000},
	{0x0F00A844, 0x1FFFFFFF},
	{0x0F00A840, 0x10000000},
	{0x0F00A048, 0xFFFFFFFF},
	{0x0F00A848, 0x0000003F},
	{0x0F00A04C, 0x00000000},
	{0x0F00A84C, 0x0000003F},
	{0x0F00A068, 0xFFFFFFFF},
	{0x0F00A084, 0x08FFFFFF},
	{0x0F00A080, 0x08000000},
	{0x0F00A00C, 0x09249249},
	{0x0F00A090, 0x24924000},								
	{0x0F00606C, 0x80000000},
	{0x0f007000, 0x00000101},
	{0x0f007004, 0x00000100},
	{0x0f00700c, 0x00010000},
	{0x0f007010, 0x01010100},
	{0x0f007014, 0x00000100},
	{0x0f007018, 0x00010100},
	{0x0f00701c, 0x00000001},
	{0x0f007020, 0x01010000},
	{0x0f007024, 0x00000100},
	{0x0f007028, 0x01010000},
	{0x0f00702c, 0x01010000},
	{0x0f007030, 0x00000101},
	{0x0f007034, 0x03030000},
	{0x0f007038, 0x00000100},
	{0x0f00703c, 0x00000000},
	{0x0f007040, 0x00000100},
	{0x0f007044, 0x03070100},
	{0x0f007048, 0x07030003},
	{0x0f00704c, 0x00010000},
	{0x0f007050, 0x03020202},
	{0x0f007054, 0x01020200},
	{0x0f007058, 0x00000100},
	{0x0f00705c, 0x060a0100},
	{0x0f007060, 0x04030305},
	{0x0f007064, 0x00000002},
	{0x0f007068, 0x01020003},
	{0x0f00706c, 0x00020007},
	{0x0f007070, 0x02030302},
	{0x0f007074, 0x00000202},
	{0x0f007078, 0x02000000},
	{0x0f00707c, 0x03020603},
	{0x0f007080, 0x00000000},
	{0x0f007084, 0x000b0000},
	{0x0f007088, 0x00320032},
	{0x0f00708c, 0x00320032},
	{0x0f007090, 0x03050000},
	{0x0f007094, 0x00150308},
	{0x0f007098, 0x00000000},
	{0x0f00709c, 0x04320000},
	{0x0f0070A0, 0x00060432},
	{0x0f0070A4, 0x00000004},
	{0x0f0070A8, 0x00000000},
	{0x0f0070Ac, 0x06120000},
	{0x0f0070B0, 0x06120612},
	{0x0f0070B4, 0x06120612},
	{0x0f0070B8, 0x05A00612},
	{0x0f0070Bc, 0xff005555},
	{0x0f0070C0, 0xaaaa00ff},
	{0x0f0070C4, 0x03e80000},
	{0x0f0070C8, 0x00000000},
	{0x0f0070Cc, 0x00000000},
	{0x0f0070D0, 0x00500000},
	{0x0f0070D4, 0x000200c8},
	{0x0f0070D8, 0x001736a6},
	{0x0f0070Dc, 0x000000c8},
	{0x0f0070E0, 0x00000028},
	{0x0f0070E4, 0x00000000},
	{0x0f0070E8, 0x00000000},
	{0x0f0070Ec, 0x00000000},
	{0x0f0070F0, 0x00000000},
	{0x0f0070F4, 0x001A18C8},
	{0x0f0070F8, 0x001A18C8},
	{0x0f0070Fc, 0x00000000},
	{0x0f007100, 0x00000000},
	{0x0f007104, 0x00000000},
	{0x0f007108, 0x000f0133},
	{0x0f00710c, 0xf4013b17},
	{0x0f007110, 0xf4013b17},
	{0x0f007114, 0x07C00300},
	{0x0f007118, 0x07C00300},
	{0x0f00711c, 0x00000005},
	{0x0f007120, 0x00000000},
	{0x0f007124, 0x00000000},
	{0x0f007128, 0x00000000},
	{0x0f00712c, 0x00000000},
	{0x0f007130, 0x00000000},
	{0x0f007134, 0x00000000},
	{0x0f007138, 0x00000000},
	{0x0f00713c, 0x00000000},
    {0x0f007140, 0x00000000},
    {0x0F00702C, 0x01010001},
	{0x0F00606C, 0x80000000},
	{0x0F00702C, 0x01010100},
};
	
static DDR_SET_NODE asBCS350_DDR2_APLL800_MEM266MHz_CLK266MHz[]= {
	{0x0F000860,0x00000000},
	{0x0F000830,0x01088888},
	{0x0F000810,0x0003E400},
	{0x0F000820,0x0C233220},
	{0x0F000880,0x0000000F},
	{0x0F008000,0x00000020},
	{0x0F008008,0x1E401010},
	{0x0F00800C,0x00008018},
	{0x0F008010,0x0000B000},
	{0x0F008014,0x0000B000},
	{0x0F008018,0x0000B000},
	{0x0F00801C,0x0000B000},
	{0x0F008020,0x0000A0F0},
	{0x0F008024,0x00006070},
	{0x0F00802C,0x00000700},
	{0x0F008030,0x00000700},
	{0x0F008034,0x00000700},
	{0x0F008038,0x00000B00},
	{0x0F00803C,0x00000B00},
	{0x0F00804C,0x00000B01},
	{0x0F008050,0x00001700},
	{0x0F008054,0x00001B00},
	{0x0F008058,0x00000A00},
	{0x0F00805C,0x00001700},
	{0x0F008060,0x00000A03},
	{0x0F008064,0x00000A03},
	{0x0F008068,0x00001700},
	{0x0F00806C,0x00001200},
	{0x0F008070,0x00001200},
	{0x0F00A044,0x1FFFFFFF},
	{0x0F00A040,0x10000000},		
	{0x0F00A844,0x1FFFFFFF},
	{0x0F00A840,0x10000000},		
	{0x0F00A048,0xFFFFFFFF},
	{0x0F00A848,0x00000000},
	{0x0F00A04C,0x00000000},		
	{0x0F00A84C,0x00000000},
	{0x0F00A068,0xFFFFFFFF},
	{0x0F00A084,0x08FFFFFF},
	{0x0F00A080,0x08000000},
	{0x0F00A00C,0x09249249},		
	{0x0F00A090,0x24924000},
	{0x0F00606C,0x80000000},
	{0x0f007000,0x00000101},
	{0x0f007004,0x00000100},
	{0x0f007008,0x01000001},
	{0x0f00700c,0x00010000},
	{0x0f007010,0x01010100},
	{0x0f007014,0x00000100},
	{0x0f007018,0x00010100},
	{0x0f00701c,0x00000001},
	{0x0f007020,0x01010000},
	{0x0f007024,0x00000100},
	{0x0f007028,0x01010000},
	{0x0f00702c,0x01010000},
	{0x0f007030,0x00000101},
	{0x0f007034,0x03030000},
	{0x0f007038,0x00000100},
	{0x0f00703c,0x00000000},
	{0x0f007040,0x00000100},
	{0x0f007044,0x03070100},
	{0x0f007048,0x07030005},
	{0x0f00704c,0x00010000},
	{0x0f007050,0x03020202},
	{0x0f007054,0x01030300},
	{0x0f007058,0x00000100},
	{0x0f00705c,0x0a0a0100},
	{0x0f007060,0x0403030a},
	{0x0f007064,0x00000002},
	{0x0f007068,0x01020005},
	{0x0f00706c,0x00020007},
	{0x0f007070,0x02040402},
	{0x0f007074,0x00000404},
	{0x0f007078,0x02000000},
	{0x0f00707c,0x04020803},
	{0x0f007080,0x00000000},
	{0x0f007084,0x000f0000},
	{0x0f007088,0x00320032},
	{0x0f00708c,0x00320032},
	{0x0f007090,0x04050000},
	{0x0f007094,0x001c040b},
	{0x0f007098,0x00000000},
	{0x0f00709c,0x06520000},
	{0x0f0070A0,0x00060652},
	{0x0f0070A4,0x00000004},
	{0x0f0070A8,0x00000000},
	{0x0f0070Ac,0x081b0000},
	{0x0f0070B0,0x081b081b},
	{0x0f0070B4,0x081b081b},
	{0x0f0070B8,0x0780081b},
	{0x0f0070Bc,0xff005555},
	{0x0f0070C0,0xaaaa00ff},
	{0x0f0070C4,0x03e80000},
	{0x0f0070C8,0x00000000},
	{0x0f0070Cc,0x00000000},
	{0x0f0070D0,0x006b0000},
	{0x0f0070D4,0x000200c8},
	{0x0f0070D8,0x001f48e1},
	{0x0f0070Dc,0x000000c8},
	{0x0f0070E0,0x00000036},
	{0x0f0070E4,0x00000000},
	{0x0f0070E8,0x00000000},
	{0x0f0070Ec,0x00000000},
	{0x0f0070F0,0x00000000},
	{0x0f0070F4,0x002010C8},
	{0x0f0070F8,0x002010C8},
	{0x0f0070Fc,0x00000000},
	{0x0f007100,0x00000000},
	{0x0f007104,0x00000000},
	{0x0f007108,0x000f0133},
	{0x0f00710c,0xf4011616},
	{0x0f007110,0xf4011616},
	{0x0f007114,0x07C00300},
	{0x0f007118,0x07C00300},
	{0x0f00711c,0x00000005},
	{0x0f007120,0x00000000},
	{0x0f007124,0x00000000},
	{0x0f007128,0x00000000},
	{0x0f00712c,0x00000000},
	{0x0f007130,0x00000000},
	{0x0f007134,0x00000000},
	{0x0f007138,0x00000000},
	{0x0f00713c,0x00000000},
	{0x0f007140,0x00000000},
	{0x0F00702C,0x01010001},
	{0x0F00606C,0x80000000},
	{0x0F00702C,0x01010100},
};


static DDR_SET_NODE asBCS350_MDDR_200MHz[]= {
	{0x0F000860,0x00000000},  
	{0x0F000830,0x02088888},
	{0x0F000810,0x0003E400},  
	{0x0F000820,0x0C233330},  
	{0x0F000880,0x0000000F},  
	{0x0F008008,0x1E401010},  
	{0x0F00800C,0x00008018},  
	{0x0F008010,0x0000B000},  
	{0x0F008014,0x0000B000},  
	{0x0F008018,0x0000B000},  
	{0x0F00801C,0x0000B000},  
	{0x0F008020,0x0000A0F0},  
	{0x0F008024,0x00006070},  
	{0x0F00802C,0x00000700},  
	{0x0F008030,0x00001000},  
	{0x0F008034,0x00000700},  
	{0x0F008038,0x00000B00},  
	{0x0F00803C,0x00000700},  
	{0x0F00804C,0x00000B01},  
	{0x0F008050,0x00001700},  
	{0x0F008054,0x00001B00},  
	{0x0F008058,0x00000A00},  
	{0x0F00805C,0x00001700},  
	{0x0F008060,0x00000A03},  
	{0x0F008064,0x00000A03},  
	{0x0F008068,0x00001700},  
	{0x0F00806C,0x00001200},  
	{0x0F008070,0x00001200}, 
	{0x0F008000,0x00000F30},
	{0x0F00606C,0x80000000},
	{0x0f007000,0x00000101},  
	{0x0f007004,0x00000100},  
	{0x0f007008,0x01000001},  
	{0x0f00700c,0x00010000},  
	{0x0f007010,0x01010100},  
	{0x0f007014,0x00010100},  
	{0x0f007018,0x00010100},  
	{0x0f00701c,0x00000001},  
	{0x0f007020,0x01010000},  
	{0x0f007024,0x00000100},  
	{0x0f007028,0x01010000},  
	{0x0f00702c,0x01010000},  
	{0x0f007030,0x00010101},  
	{0x0f007034,0x03030000},  
	{0x0f007038,0x00000100},  
	{0x0f00703c,0x00000000},  
	{0x0f007040,0x00000000},  
	{0x0f007044,0x03070200},  
	{0x0f007048,0x07040003},  
	{0x0f00704c,0x00020000},  
	{0x0f007050,0x01010202},  
	{0x0f007054,0x00000200},  
	{0x0f007058,0x00000100},  
	{0x0f00705c,0x060a0100},  
	{0x0f007060,0x01010106},  
	{0x0f007064,0x00000002},  
	{0x0f007068,0x01020003},  
	{0x0f00706c,0x00020007},  
	{0x0f007070,0x02030302},  
	{0x0f007074,0x01000101},  
	{0x0f007078,0x01000001},  
	{0x0f00707c,0x03020601},  
	{0x0f007080,0x00000000},  
	{0x0f007084,0x000b0a00},  
	{0x0f007088,0x00320032},  
	{0x0f00708c,0x00320032},  
	{0x0f007090,0x02050000},  
	{0x0f007094,0x000e0308},  
	{0x0f007098,0x00000000},  
	{0x0f00709c,0x00320000},  
	{0x0f0070A0,0x00000032},  
	{0x0f0070A4,0x00000000},  
	{0x0f0070A8,0x00000000},  
	{0x0f0070Ac,0x06120000},  
	{0x0f0070B0,0x06120612},  
	{0x0f0070B4,0x06120612},  
	{0x0f0070B8,0x06120612},  
	{0x0f0070Bc,0xff005555},  
	{0x0f0070C0,0xaaaa00ff},  
	{0x0f0070C4,0x03e80000},  
	{0x0f0070C8,0x01000000},  
	{0x0f0070Cc,0x00000000},  
	{0x0f0070D0,0x00000000},  
	{0x0f0070D4,0x00010000},  
	{0x0f0070D8,0x001036a6},  
	{0x0f0070Dc,0x00000013},  
	{0x0f0070E0,0x00000028},  
	{0x0f0070E4,0x00000000},  
	{0x0f0070E8,0x00000000},  
	{0x0f0070Ec,0x00000000},  
	{0x0f0070F0,0x00000000},  
	{0x0f0070F4,0x001A1AC8},  
	{0x0f0070F8,0x001A1AC8},  
	{0x0f0070Fc,0x00000000},  
	{0x0f007100,0x00000000},  
	{0x0f007104,0x00000000},  
	{0x0f007108,0x000f1133},  
	{0x0f00710c,0xf4003b17},  
	{0x0f007110,0xf4003b17},  
	{0x0f007114,0x07400310},  
	{0x0f007118,0x07400310},  
	{0x0f00711c,0x00800005},  
	{0x0f007120,0x00000000},  
	{0x0f007124,0x00000000},  
	{0x0f007128,0x00000000},  
	{0x0f00712c,0x00000000},  
	{0x0f007130,0x00000000},  
	{0x0f007134,0x00000000},  
	{0x0f007138,0x00000000},  
	{0x0f00713c,0x00000000},  
	{0x0f007140,0x00000000},
	{0x0F00A044,0x1FFFFFFF}, 
	{0x0F00A040,0x10000000}, 
	{0x0F00A844,0x1FFFFFFF}, 
	{0x0F00A840,0x10000000}, 
	{0x0F00A048,0xFFFFFFFF}, 
	{0x0F00A848,0x0000003F}, 
	{0x0F00A04C,0x00000000},
	{0x0F00A84C,0x0000003F}, 	
	{0x0F00A068,0xFFFFFFFF},
	{0x0F00A084,0x08FFFFFF}, 
	{0x0F00A080,0x08000000}, 
	{0x0F00A00C,0x09249249}, 
	{0x0F00A090,0x24924000},	
	{0x0F006074,0x00000011},
	{0x0F006874,0x00000011},
	{0x0F00702C,0x01010001},
	{0x0F00606C,0x80000000},
	{0x0F00702C,0x01010100},
};
static DDR_SET_NODE asBCS350_MDDR_160MHz[]= {
	{0x0F000860,0x00000000},
	{0x0F000830,0x02088888},
	{0x0F000810,0x0003E400},
	{0x0F000820,0x0C233430},
	{0x0F000880,0x0000000F},
	{0x0F008008,0x1E401010},
	{0x0F00800C,0x00008018},
	{0x0F008010,0x0000B000},
	{0x0F008014,0x0000B000},
	{0x0F008018,0x0000B000},
	{0x0F00801C,0x0000B000},
	{0x0F008020,0x0000A0F0},
	{0x0F008024,0x00006070},
	{0x0F00802C,0x00000700},
	{0x0F008030,0x00001000},
	{0x0F008034,0x00000700},
	{0x0F008038,0x00000B00},
	{0x0F00803C,0x00000B00},
	{0x0F00804C,0x00000B01},
	{0x0F008050,0x00001700},
	{0x0F008054,0x00001B00},
	{0x0F008058,0x00000A00},
	{0x0F00805C,0x00001700},
	{0x0F008060,0x00000A03},
	{0x0F008064,0x00000A03},
	{0x0F008068,0x00001700},	
	{0x0F00806C,0x00001200},
	{0x0F008070,0x00001200},
	{0x0F008000,0x00000F30},
	{0x0F00606C,0x80000000},
	{0x0F007000,0x00000101},
	{0x0F007004,0x00000100},
	{0x0F007008,0x01000001},
	{0x0F00700C,0x00010000},
	{0x0F007010,0x01010100},
	{0x0F007014,0x00010100},
	{0x0F007018,0x00010100},
	{0x0F00701C,0x00000001},
	{0x0F007020,0x01010000},
	{0x0F007024,0x00000100},
	{0x0F007028,0x01010000},
	{0x0F00702C,0x01010000},
	{0x0F007030,0x00010101},
	{0x0F007034,0x00000000},
	{0x0F007038,0x00000100},
	{0x0F00703C,0x00000000},
	{0x0F007040,0x00000000},
	{0x0F007044,0x03070200},
	{0x0F007048,0x07040003},
	{0x0F00704C,0x00020000},
	{0x0F007050,0x01010202},
	{0x0F007054,0x00000200},
	{0x0F007058,0x00000100},
	{0x0F00705C,0x060a0100},
	{0x0F007060,0x01010106},
	{0x0F007064,0x00000002},
	{0x0F007068,0x01020003},
	{0x0F00706C,0x00020006},
	{0x0F007070,0x02030302},
	{0x0F007074,0x01000101},
	{0x0F007078,0x01000001},
	{0x0F00707C,0x03020601},
	{0x0F007080,0x00000000},
	{0x0F007084,0x000a0a00},
	{0x0F007088,0x00320032},
	{0x0F00708C,0x00320032},
	{0x0F007090,0x02050000},
	{0x0F007094,0x000c0307},
	{0x0F007098,0x00000000},
	{0x0F00709C,0x00320000},
	{0x0F0070A0,0x00000032},
	{0x0F0070A4,0x00000000},
	{0x0F0070A8,0x00000000},
	{0x0F0070AC,0x050e0000},
	{0x0F0070B0,0x050e050e},
	{0x0F0070B4,0x050e050e},
	{0x0F0070B8,0x050e050e},
	{0x0F0070BC,0xff005555},
	{0x0F0070C0,0xaaaa00ff},
	{0x0F0070C4,0x03e80000},
	{0x0F0070C8,0x01000000},
	{0x0F0070CC,0x00000000},
	{0x0F0070D0,0x00000000},
	{0x0F0070D4,0x00010000},
	{0x0F0070D8,0x000e2d89},
	{0x0F0070DC,0x00000010},
	{0x0F0070E0,0x00000022},
	{0x0F0070E4,0x00000000},
	{0x0F0070E8,0x00000000},
	{0x0F0070EC,0x00000000},
	{0x0F0070F0,0x00000000},
	{0x0F0070F4,0x00080880},
	{0x0F0070F8,0x00080880},
	{0x0F0070FC,0x00000000},
	{0x0F007100,0x00000000},
	{0x0F007104,0x00000000},
	{0x0F007108,0x000f1133},
	{0x0F00710C,0xf3003a17},
	{0x0F007110,0xf3003a17},
	{0x0F007114,0x07400310},
	{0x0F007118,0x07400310},
	{0x0F00711C,0x00800004},
	{0x0F007120,0x00000000},
	{0x0F007124,0x00000000},
	{0x0F007128,0x00000000},
	{0x0F00712C,0x00000000},
	{0x0F007130,0x00000000},
	{0x0F007134,0x00000000},
	{0x0F007138,0x00000000},
	{0x0F00713C,0x00000000},
	{0x0F007140,0x00000000},
	{0x0F00A044,0x1FFFFFFF},
	{0x0F00A040,0x10000000},
	{0x0F00A844,0x1FFFFFFF},
	{0x0F00A840,0x10000000},
	{0x0F00A048,0xFFFFFFFF},
	{0x0F00A848,0x0000003F},
	{0x0F00A04C,0x00000000},
	{0x0F00A84C,0x0000003F},
	{0x0F00A068,0xFFFFFFFF},
	{0x0F00A084,0x08FFFFFF},
	{0x0F00A080,0x08000000},
	{0x0F00A00C,0x09249249},
	{0x0F00A090,0x24924000},
	{0x0F006074,0x00000011},
	{0x0F006874,0x00000011},
	{0x0F00702C,0x01010001},
	{0x0F00606C,0x80000000},
	{0x0F00702C,0x01010100},
};

int download_ddr_settings_i2c_format(PMINI_ADAPTER Adapter, PDDR_SETTING psDDRSetting, B_UINT32 RegCount)
{
	PUCHAR ddrValues = NULL;
	UINT dumpOffset = 0;
	UINT i = 0, value= 0;
	B_UINT32 ul_ddr_setting_load_addr = 0;
	
	ul_ddr_setting_load_addr = DDR_DUMP_INTERNAL_DEVICE_MEMORY_350;

	ddrValues = (PUCHAR)kmalloc(BUFFER_4K, GFP_KERNEL);	
	if(ddrValues == NULL)
	{
		BCM_DEBUG_PRINT(Adapter,DBG_TYPE_INITEXIT, DRV_ENTRY, DBG_LVL_ALL,"Failed to allocate memory for the ddr dump buffer");
		return -ENOMEM;
	}
	//bcm signature..
	ddrValues[dumpOffset++] = 0x42;
	ddrValues[dumpOffset++] = 0x45;
	ddrValues[dumpOffset++] = 0x43;
	ddrValues[dumpOffset++] = 0x4D;

	
	//C0 =>H/W Write command followed by register and value.
	//C1 =>H/W read command followed by register.

	//next two lines are the part of I2c EEPROM pattern
	ddrValues[dumpOffset++] = 0x50;
	ddrValues[dumpOffset++] = 0x00;

	for(i = 0; i < RegCount; i++)
	{
		ddrValues[dumpOffset++] = 0xC0;
		value = htonl(psDDRSetting->ulRegAddress);
		memcpy((ddrValues + dumpOffset), &value, sizeof(B_UINT32));
		dumpOffset += 4;
		value = htonl(psDDRSetting->ulRegValue);
		memcpy((ddrValues + dumpOffset), &value, sizeof(B_UINT32));
		dumpOffset += 4;
		psDDRSetting++;
	}
	//Putting MIPS out of reset.
	ddrValues[dumpOffset++] = 0xC1;
	ddrValues[dumpOffset++] = 0x0F;
	ddrValues[dumpOffset++] = 0x00;
	ddrValues[dumpOffset++] = 0x60;
	ddrValues[dumpOffset++] = 0x50;
	ddrValues[dumpOffset++] = 0xC1;
	ddrValues[dumpOffset++] = 0x0F;
	ddrValues[dumpOffset++] = 0x00;
	ddrValues[dumpOffset++] = 0x60;
	ddrValues[dumpOffset++] = 0x50;
	ddrValues[dumpOffset++] = 0xC0;
	ddrValues[dumpOffset++] = 0x0F;
	ddrValues[dumpOffset++] = 0x00;
	ddrValues[dumpOffset++] = 0x60;
	ddrValues[dumpOffset++] = 0x50;
	ddrValues[dumpOffset++] = 0x00;
	ddrValues[dumpOffset++] = 0x00;
	ddrValues[dumpOffset++] = 0x00;
	ddrValues[dumpOffset++] = 0x7F;
	
	//part of the I2c EEPROM Header
	ddrValues[dumpOffset++] = 0x00;
	ddrValues[dumpOffset++] = 0x80;
	ddrValues[dumpOffset++] = 0x00;

	value = DDR_DUMP_MAGIC_PATTERN;	/* UL pattern */
	wrmalt(Adapter, ul_ddr_setting_load_addr, &value, sizeof(B_UINT32));
	ul_ddr_setting_load_addr += sizeof(B_UINT32);
	value = dumpOffset;
	wrmalt(Adapter, ul_ddr_setting_load_addr, &value, sizeof(B_UINT32));
	ul_ddr_setting_load_addr += sizeof(B_UINT32);

	/* Need to make buffer (as dumped usnig wrm) multiple of 4... hence padding it with '0' */
	while(dumpOffset%4)
	{
		ddrValues[dumpOffset++] = 0x00;
	}
	wrm(Adapter, ul_ddr_setting_load_addr, ddrValues, dumpOffset); 
	bcm_kfree(ddrValues);
	
	return STATUS_SUCCESS;
	
}

int ddr_init(MINI_ADAPTER *Adapter)
{
	PDDR_SETTING psDDRSetting=NULL;
	B_UINT32 RegCount=0;
	B_UINT32 value = 0;	
	UINT  uiResetValue = 0;
	UINT uiClockSetting = 0;
	int retval = STATUS_SUCCESS;

    switch (Adapter->chip_id)
	{
	case 0xbece3200:
	    switch (Adapter->DDRSetting)
	    {
	        case DDR_80_MHZ:
				psDDRSetting=asT3LP_DDRSetting80MHz;
			    RegCount=(sizeof(asT3LP_DDRSetting80MHz)/
			  	sizeof(DDR_SETTING));
			    break;
		    case DDR_100_MHZ:
				psDDRSetting=asT3LP_DDRSetting100MHz;
			    RegCount=(sizeof(asT3LP_DDRSetting100MHz)/
			  	sizeof(DDR_SETTING));
			    break;
		    case DDR_133_MHZ:
				psDDRSetting=asT3LP_DDRSetting133MHz;
			    RegCount=(sizeof(asT3LP_DDRSetting133MHz)/
		 	  		sizeof(DDR_SETTING));
				if(Adapter->bMipsConfig == MIPS_200_MHZ)
				{
					uiClockSetting = 0x03F13652;											
				}
				else
				{
					uiClockSetting = 0x03F1365B;
				}	
				break;
		    default:
			    return -EINVAL;
        }
		
		break;
	case T3LPB:
	case BCS220_2:
	case BCS220_2BC:
	case BCS250_BC:
	case BCS220_3 :	
		/* Set bit 2 and bit 6 to 1 for BBIC 2mA drive 
		 * (please check current value and additionally set these bits)
		 */
		if( (Adapter->chip_id !=  BCS220_2) && 
			(Adapter->chip_id !=  BCS220_2BC) &&
			(Adapter->chip_id != BCS220_3) ) 
		{
				retval= rdmalt(Adapter,(UINT)0x0f000830, &uiResetValue, sizeof(uiResetValue));
				if(retval < 0) {
					BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
					return retval;
				}	
				uiResetValue |= 0x44;
				retval = wrmalt(Adapter,(UINT)0x0f000830, &uiResetValue, sizeof(uiResetValue));
				if(retval < 0) {
					BCM_DEBUG_PRINT(Adapter,CMHOST, WRM, DBG_LVL_ALL, "%s:%d WRM failed\n", __FUNCTION__, __LINE__);
					return retval;
				}
		}
		switch(Adapter->DDRSetting)
		{
			
			
				
			case DDR_80_MHZ:
				psDDRSetting = asT3LPB_DDRSetting80MHz;
		        RegCount=(sizeof(asT3B_DDRSetting80MHz)/
		                  sizeof(DDR_SETTING));
			break;
            case DDR_100_MHZ:
				psDDRSetting=asT3LPB_DDRSetting100MHz;
		        RegCount=(sizeof(asT3B_DDRSetting100MHz)/
		                 sizeof(DDR_SETTING));
			break;
            case DDR_133_MHZ:
				psDDRSetting = asT3LPB_DDRSetting133MHz;
				RegCount=(sizeof(asT3B_DDRSetting133MHz)/
						 sizeof(DDR_SETTING));
				
				if(Adapter->bMipsConfig == MIPS_200_MHZ)
				{
					uiClockSetting = 0x03F13652;										
				}
				else
				{
					uiClockSetting = 0x03F1365B;
				}
			break;
			
			case DDR_160_MHZ:
				psDDRSetting = asT3LPB_DDRSetting160MHz;
				RegCount = sizeof(asT3LPB_DDRSetting160MHz)/sizeof(DDR_SETTING);

				if ( Adapter->bHarqCat5Enable == 0x00 )
				{
					/* Restore the old values for asT3LPB_DDRSetting160MHz */
					if(asT3LPB_DDRSetting160MHz[1].ulRegAddress == 0x0f000810)
						asT3LPB_DDRSetting160MHz[1].ulRegValue = 0x01842795;
					else 
						BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"Error!! Register value mismatch 0x0f000810\n");

					if(asT3LPB_DDRSetting160MHz[4].ulRegAddress == 0x0f000840)
						asT3LPB_DDRSetting160MHz[4].ulRegValue = 0x0FFF0400;
					else
						BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"Error!! Register value mismatch 0x0f000840\n");

					if(asT3LPB_DDRSetting160MHz[11].ulRegAddress == 0x0f007004 )
						asT3LPB_DDRSetting160MHz[11].ulRegValue = 0x01000001;
					else
						BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"Error!! Register value mismatch 0x0f007004\n");
						
					// We use default Sys_config. I.e. 800Mhz PLL. 
					if(Adapter->bMipsConfig == MIPS_200_MHZ)
					{
						// MIPS/XBAR = 200, MAC/BD=160 DDR = 160Mhz.
						// DDR is at 160 because 840 - bit 10 is 1.
						uiClockSetting = 0x03F137D2;
						if(asT3LPB_DDRSetting160MHz[11].ulRegAddress == 0x0f007004 )
						{
							asT3LPB_DDRSetting160MHz[11].ulRegValue = 0x01000000;
							BCM_DEBUG_PRINT(Adapter,DBG_TYPE_INITEXIT, DRV_ENTRY, DBG_LVL_ALL,"-------->MIPS/XBAR = 200 MAC/BD/DDR = 160<----------\n");
						}
						else
						{
							BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"Error!! Register value mismatch 0x0f007004\n");
						}
						
					}
					else
					{
						// MIPS/XBAR = 160, MAC/BD=160 DDR = 160Mhz.
						// DDR is at 160 because 840 - bit 10 is 1.
						uiClockSetting = 0x03F137DB;
						BCM_DEBUG_PRINT(Adapter,DBG_TYPE_INITEXIT, DRV_ENTRY, DBG_LVL_ALL,"-------->MIPS/XBAR/MAC/BD/DDR = 160<----------\n");
					}
					
				} 
				else 
				{
					UINT uiSysConfigValue = 0;
					/* Use the new values for asT3LPB_DDRSetting160MHz */
					if(asT3LPB_DDRSetting160MHz[1].ulRegAddress == 0x0f000810)
						asT3LPB_DDRSetting160MHz[1].ulRegValue = 0x00002f95;
					else
						BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"Error!! Register value mismatch 0x0f000810\n");

					if(asT3LPB_DDRSetting160MHz[4].ulRegAddress == 0x0f000840)
						asT3LPB_DDRSetting160MHz[4].ulRegValue = 0x0FFF0000;
					else
						BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"Error!! Register value mismatch 0x0f000840\n");

					if(asT3LPB_DDRSetting160MHz[11].ulRegAddress == 0x0f007004 )
						asT3LPB_DDRSetting160MHz[11].ulRegValue = 0x01000000;
					else
						BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"Error!! Register value mismatch 0x0f007004\n");
						
					
					rdmalt(Adapter, SYS_CFG, &uiSysConfigValue, sizeof(uiSysConfigValue) );
					BCM_DEBUG_PRINT(Adapter,DBG_TYPE_INITEXIT, DRV_ENTRY, DBG_LVL_ALL,"--------->DDR 160 is selected/executing SYS %x<------------\n",uiSysConfigValue);
					// Clear bit 18 - selects 960Mhz.
					uiSysConfigValue = uiSysConfigValue & 0xFFFBFFFF;
					// Set bit 7 
					uiSysConfigValue = uiSysConfigValue | 0x80;
					retval = updateWriteProtectedRegister(Adapter, SYS_CFG, uiSysConfigValue);
					if(retval) 
					{
						BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"write SYS_CFG failed with status :%d",retval);
						return retval;
					}
					
					rdmalt(Adapter, SYS_CFG, &uiSysConfigValue, sizeof(uiSysConfigValue));
					BCM_DEBUG_PRINT(Adapter,DBG_TYPE_INITEXIT, DRV_ENTRY, DBG_LVL_ALL,"-------->MIPS/XBAR/BD = 192 & DDR/MAC = 160 /SYSCONFIG %x<----------\n",uiSysConfigValue);

					// MIPS/XBAR/BD = 192, MAC/DDR = 160
					uiClockSetting = 0x03F1385B;
					// MIPS/XBAR = 192, BD/MAC/DDR = 160
					// uiClockSetting = 0x04F1385B;
				}
			}
			break;
		
	case 0xbece0110:
	case 0xbece0120:
	case 0xbece0121:
	case 0xbece0130:
	case 0xbece0300:
		BCM_DEBUG_PRINT(Adapter,DBG_TYPE_INITEXIT, DRV_ENTRY, DBG_LVL_ALL, "DDR Setting: %x\n", Adapter->DDRSetting);
	    switch (Adapter->DDRSetting)
	    {
	        case DDR_80_MHZ:
				psDDRSetting = asT3_DDRSetting80MHz;
			    RegCount = (sizeof(asT3_DDRSetting80MHz)/
			  	sizeof(DDR_SETTING));
			    break;
		    case DDR_100_MHZ:
				psDDRSetting = asT3_DDRSetting100MHz;
			    RegCount = (sizeof(asT3_DDRSetting100MHz)/
			  	sizeof(DDR_SETTING));
			    break;
		    case DDR_133_MHZ:
				psDDRSetting = asT3_DDRSetting133MHz;
			    RegCount = (sizeof(asT3_DDRSetting133MHz)/
		 	  	sizeof(DDR_SETTING));
				break;
		    default:
			    return -EINVAL;
        }
	case 0xbece0310:
	{
	    switch (Adapter->DDRSetting)	        
	    {
	        case DDR_80_MHZ:
				psDDRSetting = asT3B_DDRSetting80MHz;
		        RegCount=(sizeof(asT3B_DDRSetting80MHz)/
		                  sizeof(DDR_SETTING));
		    break;
            case DDR_100_MHZ:
				psDDRSetting=asT3B_DDRSetting100MHz;
		        RegCount=(sizeof(asT3B_DDRSetting100MHz)/
		                 sizeof(DDR_SETTING));
			break;
            case DDR_133_MHZ:
			    
				if(Adapter->bDPLLConfig == PLL_266_MHZ)//266Mhz PLL selected.
				{
					memcpy(asT3B_DDRSetting133MHz, asDPLL_266MHZ,
									 sizeof(asDPLL_266MHZ));
					psDDRSetting = asT3B_DDRSetting133MHz;
					RegCount=(sizeof(asT3B_DDRSetting133MHz)/ 
									sizeof(DDR_SETTING));	
				}
				else
				{
					psDDRSetting = asT3B_DDRSetting133MHz;
					RegCount=(sizeof(asT3B_DDRSetting133MHz)/ 
									sizeof(DDR_SETTING));
					if(Adapter->bMipsConfig == MIPS_200_MHZ)
					{
						uiClockSetting = 0x07F13652;											
					}
					else
					{
						uiClockSetting = 0x07F1365B;
					}
				}
				break;	
		    default:
			    return -EINVAL;
		}
		break;
		
	}

    case BCS5350AB:  
    case BCS5350BC: 
	case BCS5350:
		switch(Adapter->DDRSetting)	{
		case BCS350_DDR200:
			psDDRSetting=asBCS350_DDR2_APLL200_DDR_200MHz;
			RegCount=sizeof(asBCS350_DDR2_APLL200_DDR_200MHz)/sizeof(DDR_SETTING);
			break;	
		case BCS350_DDR266:
			psDDRSetting=asBCS350_DDR2_APLL800_MEM266MHz_CLK266MHz;
			RegCount=sizeof(asBCS350_DDR2_APLL800_MEM266MHz_CLK266MHz)/sizeof(DDR_SETTING);
			break;
		default:
			psDDRSetting=asBCS350_DDR2_APLL200_DDR_200MHz;
			RegCount=sizeof(asBCS350_DDR2_APLL200_DDR_200MHz)/sizeof(DDR_SETTING);
			break;
		}
		break;

	case BCS350:
		switch(Adapter->DDRSetting)
		{
		case BCS350_DDR200:
			psDDRSetting = asBCS350_MDDR_200MHz;
			RegCount = sizeof(asBCS350_MDDR_200MHz)/sizeof(DDR_SETTING);
			break;
		
		default:
        case BCS350_DDR160:	
			psDDRSetting = asBCS350_MDDR_160MHz;
			RegCount = sizeof(asBCS350_MDDR_160MHz)/sizeof(DDR_SETTING);
			break;
		}
		break;
  
	
 //Chip BCSM351
    case BCSM351    :     
    case BCSM351AB  :  
    case BCSM351BC  : 

 //Chip BCSM352-2 
    case BCSM352_2AB: 
    case BCSM352_2BC:
    
 //chip E350
    case E350       :    
    case E350AB     :      
    case E350BC     :     
        
 //chip   BCS350
    case BCS350BC   :
    case BCS350AB   :
		switch(Adapter->DDRSetting)
		{
		case BCS350_DDR200:
		default:
			psDDRSetting = asBCS350_MDDR_200MHz;
			RegCount = sizeof(asBCS350_MDDR_200MHz)/sizeof(DDR_SETTING);
			break;
		}
		break;
	
	default:
		return -EINVAL;
	}
	
	value=0;
	BCM_DEBUG_PRINT(Adapter,DBG_TYPE_INITEXIT, DRV_ENTRY, DBG_LVL_ALL, "Register Count is =%u\n", RegCount);
	while(RegCount && !retval)
	{
		if(uiClockSetting && psDDRSetting->ulRegAddress == MIPS_CLOCK_REG)
		{
			value = uiClockSetting;
		}
		else
		{
			value = psDDRSetting->ulRegValue;
		}
		retval = wrmalt(Adapter, psDDRSetting->ulRegAddress, (PUINT)&value, sizeof(value));
		if(STATUS_SUCCESS != retval) {
			BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"%s:%d\n", __FUNCTION__, __LINE__);
			break;
		}	
		
		RegCount--;
		psDDRSetting++;
	}


    if((Adapter->chip_id >= T3LPB)  && (Adapter->chip_id < BCS350))
	{
	
		mdelay(3);
		if( (Adapter->chip_id != BCS220_2)&&
			(Adapter->chip_id != BCS220_2BC)&& 
			(Adapter->chip_id != BCS220_3))
		{
			/* drive MDDR to half in case of UMA-B:	*/
			uiResetValue = 0x01010001;
			retval = wrmalt(Adapter, (UINT)0x0F007018, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			uiResetValue = 0x00040020;
			retval = wrmalt(Adapter, (UINT)0x0F007094, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			uiResetValue = 0x01020101;
			retval = wrmalt(Adapter, (UINT)0x0F00701c, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			uiResetValue = 0x01010000;
			retval = wrmalt(Adapter, (UINT)0x0F007018, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
		}	
		mdelay(3);
		
		/* DC/DC standby change...
		 * This is to be done only for Hybrid PMU mode.
		 * with the current h/w there is no way to detect this.
		 * and since we dont have internal PMU lets do it under UMA-B chip id.
	     * we will change this when we will have internal PMU.
	     */
		if(Adapter->PmuMode == HYBRID_MODE_7C)
		{
			retval = rdmalt(Adapter,(UINT)0x0f000c00, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			retval = rdmalt(Adapter,(UINT)0x0f000c00, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			uiResetValue = 0x1322a8;
			retval = wrmalt(Adapter, (UINT)0x0f000d1c, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			retval = rdmalt(Adapter,(UINT)0x0f000c00, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			retval = rdmalt(Adapter,(UINT)0x0f000c00, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			uiResetValue = 0x132296;	
			retval = wrmalt(Adapter, (UINT)0x0f000d14, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
		}
		else if(Adapter->PmuMode == HYBRID_MODE_6 )
		{

			retval = rdmalt(Adapter,(UINT)0x0f000c00, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			retval = rdmalt(Adapter,(UINT)0x0f000c00, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			uiResetValue = 0x6003229a;
			retval = wrmalt(Adapter, (UINT)0x0f000d14, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			retval = rdmalt(Adapter,(UINT)0x0f000c00, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			retval = rdmalt(Adapter,(UINT)0x0f000c00, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
			uiResetValue = 0x1322a8;	
			retval = wrmalt(Adapter, (UINT)0x0f000d1c, &uiResetValue, sizeof(uiResetValue));
			if(retval < 0) {
				BCM_DEBUG_PRINT(Adapter,CMHOST, RDM, DBG_LVL_ALL, "%s:%d RDM failed\n", __FUNCTION__, __LINE__);
				return retval;
			}
		}
		
	}
	Adapter->bDDRInitDone = TRUE;
	return retval;
}

int download_ddr_settings(PMINI_ADAPTER Adapter)
{
	PDDR_SET_NODE psDDRSetting=NULL;
	B_UINT32 RegCount=0;
	unsigned long ul_ddr_setting_load_addr = DDR_DUMP_INTERNAL_DEVICE_MEMORY;
	UINT  value = 0; 
	int retval = STATUS_SUCCESS;
	BOOLEAN bOverrideSelfRefresh = FALSE;

    if(Adapter->chip_id >= BCS350)
	{
		ul_ddr_setting_load_addr = DDR_DUMP_INTERNAL_DEVICE_MEMORY_350;
	}
	
	switch (Adapter->chip_id)
	{
	case 0xbece3200:
	    switch (Adapter->DDRSetting)
	    {
	        case DDR_80_MHZ:
				psDDRSetting = asT3LP_DDRSetting80MHz;
                RegCount = (sizeof(asT3LP_DDRSetting80MHz)/sizeof(DDR_SET_NODE));
				RegCount -= T3LP_SKIP_CLOCK_PROGRAM_DUMP_80MHZ ;
                psDDRSetting += T3LP_SKIP_CLOCK_PROGRAM_DUMP_80MHZ;
			break;
		    case DDR_100_MHZ:
				psDDRSetting = asT3LP_DDRSetting100MHz;
			    RegCount = (sizeof(asT3LP_DDRSetting100MHz)/sizeof(DDR_SET_NODE));
				RegCount -= T3LP_SKIP_CLOCK_PROGRAM_DUMP_100MHZ ;
                psDDRSetting += T3LP_SKIP_CLOCK_PROGRAM_DUMP_100MHZ;		
			    break;
		     case DDR_133_MHZ:
				bOverrideSelfRefresh = TRUE;
				psDDRSetting = asT3LP_DDRSetting133MHz;
			    RegCount = (sizeof(asT3LP_DDRSetting133MHz)/sizeof(DDR_SET_NODE));
				RegCount -= T3LP_SKIP_CLOCK_PROGRAM_DUMP_133MHZ ;
		        psDDRSetting += T3LP_SKIP_CLOCK_PROGRAM_DUMP_133MHZ;			
				break;
			default:
			    return -EINVAL;
        }
		break;
	
	case T3LPB:
	case BCS220_2:
	case BCS220_2BC:	
	case BCS250_BC:
	case BCS220_3 :	
	    switch (Adapter->DDRSetting)
	    {
	        case DDR_80_MHZ:
				psDDRSetting = asT3LPB_DDRSetting80MHz;
                RegCount=(sizeof(asT3LPB_DDRSetting80MHz)/sizeof(DDR_SET_NODE));
				RegCount -= T3LPB_SKIP_CLOCK_PROGRAM_DUMP_80MHZ ;
                psDDRSetting += T3LPB_SKIP_CLOCK_PROGRAM_DUMP_80MHZ;
			break;
		    case DDR_100_MHZ:
				psDDRSetting = asT3LPB_DDRSetting100MHz;
			    RegCount = (sizeof(asT3LPB_DDRSetting100MHz)/sizeof(DDR_SET_NODE));
				RegCount -= T3LPB_SKIP_CLOCK_PROGRAM_DUMP_100MHZ ;
                psDDRSetting += T3LPB_SKIP_CLOCK_PROGRAM_DUMP_100MHZ;		
			    break;
		     case DDR_133_MHZ:
				bOverrideSelfRefresh = TRUE;
				psDDRSetting = asT3LPB_DDRSetting133MHz;
			    RegCount = (sizeof(asT3LPB_DDRSetting133MHz)/sizeof(DDR_SET_NODE));
				RegCount -= T3LPB_SKIP_CLOCK_PROGRAM_DUMP_133MHZ ;
		        psDDRSetting += T3LPB_SKIP_CLOCK_PROGRAM_DUMP_133MHZ;			
				break;
				
			case DDR_160_MHZ:
					bOverrideSelfRefresh = TRUE;
					psDDRSetting = asT3LPB_DDRSetting160MHz;
					RegCount = sizeof(asT3LPB_DDRSetting160MHz)/sizeof(DDR_SET_NODE);
					RegCount -= T3LPB_SKIP_CLOCK_PROGRAM_DUMP_160MHZ;
					psDDRSetting += T3LPB_SKIP_CLOCK_PROGRAM_DUMP_160MHZ;
						
					break;	
			default:
			    return -EINVAL;
        }
		break;
	case 0xbece0300:
	    switch (Adapter->DDRSetting)
	    {
	        case DDR_80_MHZ:
				psDDRSetting = asT3_DDRSetting80MHz;
                RegCount = (sizeof(asT3_DDRSetting80MHz)/sizeof(DDR_SET_NODE));
				RegCount-=T3_SKIP_CLOCK_PROGRAM_DUMP_80MHZ ;
                psDDRSetting += T3_SKIP_CLOCK_PROGRAM_DUMP_80MHZ;
			break;
		    case DDR_100_MHZ:
				psDDRSetting = asT3_DDRSetting100MHz;
			    RegCount = (sizeof(asT3_DDRSetting100MHz)/sizeof(DDR_SET_NODE));
				RegCount-=T3_SKIP_CLOCK_PROGRAM_DUMP_100MHZ ;
                psDDRSetting += T3_SKIP_CLOCK_PROGRAM_DUMP_100MHZ;		
			    break;
		     case DDR_133_MHZ:
				psDDRSetting = asT3_DDRSetting133MHz;
			    RegCount = (sizeof(asT3_DDRSetting133MHz)/sizeof(DDR_SET_NODE));
				RegCount-=T3_SKIP_CLOCK_PROGRAM_DUMP_133MHZ ;
		        psDDRSetting += T3_SKIP_CLOCK_PROGRAM_DUMP_133MHZ ;		
				break;
			default:
			    return -EINVAL;
        }
	break;
	case 0xbece0310:
	    {
		    switch (Adapter->DDRSetting)	        
		    {
		        case DDR_80_MHZ:
					psDDRSetting = asT3B_DDRSetting80MHz;
                    RegCount = (sizeof(asT3B_DDRSetting80MHz)/sizeof(DDR_SET_NODE));
                    RegCount -= T3B_SKIP_CLOCK_PROGRAM_DUMP_80MHZ ;
                    psDDRSetting += T3B_SKIP_CLOCK_PROGRAM_DUMP_80MHZ;
			        break;
		        case DDR_100_MHZ:
					psDDRSetting = asT3B_DDRSetting100MHz;
			        RegCount = (sizeof(asT3B_DDRSetting100MHz)/sizeof(DDR_SET_NODE));
                    RegCount -= T3B_SKIP_CLOCK_PROGRAM_DUMP_100MHZ ;
                    psDDRSetting += T3B_SKIP_CLOCK_PROGRAM_DUMP_100MHZ;		
			        break;
		        case DDR_133_MHZ:
					bOverrideSelfRefresh = TRUE;
					psDDRSetting = asT3B_DDRSetting133MHz;
			        RegCount = (sizeof(asT3B_DDRSetting133MHz)/sizeof(DDR_SET_NODE));
	                RegCount -= T3B_SKIP_CLOCK_PROGRAM_DUMP_133MHZ ;
		            psDDRSetting += T3B_SKIP_CLOCK_PROGRAM_DUMP_133MHZ;			
					break;
		      }
		      break;
	     }
		case BCS350:
		{
			switch(Adapter->DDRSetting)	{
			case BCS350_DDR200:
				psDDRSetting = asBCS350_MDDR_200MHz;
				RegCount = sizeof(asBCS350_MDDR_200MHz)/sizeof(DDR_SET_NODE);
				break;
			
			default:
            case BCS350_DDR160:
				psDDRSetting = asBCS350_MDDR_160MHz;
				RegCount = sizeof(asBCS350_MDDR_160MHz)/sizeof(DDR_SET_NODE);
				break;
			}

            if(DEVICE_POWERSAVE_MODE_AS_PMU_SHUTDOWN == Adapter->ulPowerSaveMode)   {
	       	    return download_ddr_settings_i2c_format(Adapter,psDDRSetting,RegCount);
    			break;
            }
            else {

                break;
			}
            
		}

    //Chip BCSM351
        case BCSM351    :     
        case BCSM351AB  :  
        case BCSM351BC  : 

    //Chip BCSM352-2 
        case BCSM352_2AB: 
        case BCSM352_2BC:
    
    //chip E350
        case E350       :    
        case E350AB     :      
        case E350BC     :     
        
    //chip   BCS350
        case BCS350BC   :
        case BCS350AB   :
		{
			switch(Adapter->DDRSetting)	{
			case BCS350_DDR200:
			default:
				psDDRSetting = asBCS350_MDDR_200MHz;
				RegCount = sizeof(asBCS350_MDDR_200MHz)/sizeof(DDR_SET_NODE);
				break;
			}

            if(DEVICE_POWERSAVE_MODE_AS_PMU_SHUTDOWN == Adapter->ulPowerSaveMode)   {
	       	    return download_ddr_settings_i2c_format(Adapter,psDDRSetting,RegCount);
    			break;
            }
            else {
                break;
			}
		}
		
            
	default:
		return -EINVAL;
	}
	//total number of Register that has to be dumped
	value =RegCount  ;
	retval = wrmalt(Adapter, ul_ddr_setting_load_addr, &value, sizeof(value));
	if(retval)
	{
		BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"%s:%d\n", __FUNCTION__, __LINE__);
        
		return retval;
	}
	ul_ddr_setting_load_addr+=sizeof(B_UINT32);
	/*signature */
	value =(DDR_DUMP_MAGIC_PATTERN);
	retval = wrmalt(Adapter, ul_ddr_setting_load_addr, &value, sizeof(value));
	if(retval)
	{
		BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"%s:%d\n", __FUNCTION__, __LINE__);
		return retval;
	}
	
	ul_ddr_setting_load_addr+=sizeof(B_UINT32);
	RegCount*=(sizeof(DDR_SETTING)/sizeof(B_UINT32));
	
	while(RegCount && !retval)
	{
		value = psDDRSetting->ulRegAddress ;
		retval = wrmalt( Adapter, ul_ddr_setting_load_addr, &value, sizeof(value));
		ul_ddr_setting_load_addr+=sizeof(B_UINT32);
		if(!retval)
		{
			if(bOverrideSelfRefresh && (psDDRSetting->ulRegAddress == 0x0F007018))
			{
				value = (psDDRSetting->ulRegValue |(1<<8));
				if(STATUS_SUCCESS != wrmalt(Adapter, ul_ddr_setting_load_addr, 
						&value, sizeof(value))){
					BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"%s:%d\n", __FUNCTION__, __LINE__);
					break;
				}
			}
			else
			{
				value =  psDDRSetting->ulRegValue;
			
				if(STATUS_SUCCESS != wrmalt(Adapter, ul_ddr_setting_load_addr ,
							&value, sizeof(value))){
					BCM_DEBUG_PRINT(Adapter,DBG_TYPE_PRINTK, 0, 0,"%s:%d\n", __FUNCTION__, __LINE__);
					break;
				}
			}
		}
		ul_ddr_setting_load_addr+=sizeof(B_UINT32);
		RegCount--;
		psDDRSetting++;
	}
	return retval;
}

#endif

